#!/usr/bin/env python3
import os
import sys

FIFO = '/tmp/myfifo'
BUFFER_SIZE = 1024

# Create the FIFO if it doesn't exist
try:
    os.mkfifo(FIFO, 0o666)
except FileExistsError:
    pass
except OSError as err:
	print("OS error: {0}".format(err))

# Open FIFO for writing (this will block until a reader opens it)
fd = os.open(FIFO, os.O_WRONLY)

# Read from stdin and write to FIFO
try:
    while True:
        data = os.read(sys.stdin.fileno(), BUFFER_SIZE)
        if not data:
            break  # stdin closed, EOF
        os.write(fd, data)
finally:
    os.close(fd)
