#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>

#define FIFO_PATH "/tmp/myfifo"
#define BUFFER_SIZE 1024

int main(void) {
        if (mkfifo(FIFO_PATH, 0666) < 0) {
        if (errno != EEXIST) {
            perror("mkfifo");
            exit(EXIT_FAILURE);
        }
    }

  
    int fd = open(FIFO_PATH, O_WRONLY);
    if (fd < 0) {
        perror(“open writing”);
        exit(EXIT_FAILURE);
    }

    // Leer de stdin y escribir en el FIFO
    char buf[BUFFER_SIZE];
    ssize_t n;
    while ((n = read(STDIN_FILENO, buf, BUFFER_SIZE)) > 0) {
        if (write(fd, buf, n) != n) {
            perror("write FIFO");
            close(fd);
            exit(EXIT_FAILURE);
        }
    }
    if (n < 0) {
        perror("read stdin");
    }

    close(fd);
    return 0;
}
