#!/usr/bin/env python3
import os
import sys

FIFO = '/tmp/myfifo'
BUFFER_SIZE = 1024

# Create the FIFO if it doesn't exist
try:
    os.mkfifo(FIFO, 0o666)
except FileExistsError:
    pass
except OSError as err:
	print("OS error: {0}".format(err))

# Open FIFO for reading (this will block until a writer opens it)
fd = os.open(FIFO, os.O_RDONLY)

# Read from FIFO and write to stdout
try:
    while True:
        data = os.read(fd, BUFFER_SIZE)
        if not data:
            break  # writer closed, EOF
        os.write(sys.stdout.fileno(), data)
finally:
    os.close(fd)
