#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>

#define FIFO_PATH "/tmp/myfifo"
#define BUFFER_SIZE 1024

int main(void) {
    
    if (mkfifo(FIFO_PATH, 0666) < 0) {
        if (errno != EEXIST) {
            perror("mkfifo");
            exit(EXIT_FAILURE);
        }
    }

   
    int fd = open(FIFO_PATH, O_RDONLY);
    if (fd < 0) {
        perror("open reading");
        exit(EXIT_FAILURE);
    }

        char buf[BUFFER_SIZE];
    ssize_t n;
    while ((n = read(fd, buf, BUFFER_SIZE)) > 0) {
        if (write(STDOUT_FILENO, buf, n) != n) {
            perror("write stdout");
            close(fd);
            exit(EXIT_FAILURE);
        }
    }
    if (n < 0) {
        perror("read FIFO");
    }

    close(fd);
    return 0;
}
