# fork-signal

import os
import sys
import time
import signal
import traceback

def check_status(pid, status):
    if os.WIFEXITED(status):
        code = os.WEXITSTATUS(status)
        print("Process ", pid, "ends because an exit with exit code ", code)
    else:
        signum = os.WTERMSIG(status)
        print("Process ", pid, "ends because a sginal number ", signum)
    return 0

def child_handler(signum, frame):
    [pid, status] = os.waitpid(-1, os.WNOHANG)
    check_status(pid, status)
    return 0

signal.signal(signal.SIGCHLD, child_handler)
pid = os.fork()
if pid == 0:
    sys.exit(0)
while True:
    pass