#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/time.h>


int main(int argc, char * argv [])
{
   int res;
   void *p;
   struct timeval tv0, tv1;
   double secs, secs2;
   int n = 2, i;
   int howmuch = 10; //499850;

   if (argc > 1) {
      fprintf(stderr, "Us: %s\n", argv[0]);
      exit(1);
   }

   /* Fake call to warm-up */
   res = gettimeofday(&tv0, NULL);
   if (res < 0) { 
      perror ("gettimeofday");
   }
   /* Fake call to warm-up */
   usleep(100);

   printf ("Reports errors when the \"secs2\" computation is different from\n"
           "the correct time in \"secs\"\n");

   for (;;) {

   printf ("Will sleep for %d microsecs per usleep\n", howmuch);

   res = gettimeofday(&tv0, NULL);
   if (res < 0) { 
      perror ("gettimeofday");
   }

   for (i=0; i < n; i++) {
      res = usleep(howmuch);
      if (res < 0) {
         perror ("sleep");
      }
   }

   res = gettimeofday(&tv1, NULL);
   if (res < 0) {
      perror ("gettimeofday");
   }

   // correct formula!!
   secs = (((double)tv1.tv_sec*1000000.0 + (double)tv1.tv_usec) - 
          ((double)tv0.tv_sec*1000000.0 + (double)tv0.tv_usec))/1000000.0;

   //// incorrect formula!!!!
   secs2 = (tv1.tv_sec - tv0.tv_sec) + ((tv1.tv_usec - tv0.tv_usec)/1000000.0);

   if (secs!=secs2) {
      printf ("  Error %.24lf\n      %.24lf!!!\n", secs, secs2);
      printf ("  tv0      %lu      %lu\n", (unsigned long) tv0.tv_sec, (unsigned long) tv0.tv_usec);
      printf ("  tv1      %lu      %lu\n", (unsigned long) tv1.tv_sec, (unsigned long) tv1.tv_usec);
      printf ("  diff     %ld      %ld\n", (long) (tv1.tv_sec - tv0.tv_sec), (long) (tv1.tv_usec - tv0.tv_usec));
   }
   if (tv1.tv_usec - tv0.tv_usec < 0) printf ("   Negative!!   %lu     %lu     %ld\n", (unsigned long) tv0.tv_usec, (unsigned long) tv1.tv_usec, (long) tv1.tv_usec - tv0.tv_usec);
   printf (" secs   %.8lf s. (%le s/sleep)\n", secs, secs / n );
   printf (" secs2  %.8lf s. (%le s/sleep)\n", secs2, secs2 / n );

   //// much better way to compute the time difference...
   //// based on the higher precision of floating point representation
   //// in the [-1.0,1.0] interval

   tv1.tv_sec -= tv0.tv_sec;   // substract the number of seconds
   tv0.tv_sec = 0;     // thus bringing the time measurements closer to 1970

   secs = (  ((double)tv1.tv_sec*1000000.0         + (double)tv1.tv_usec) - 
          ( /*(double)tv0.tv_sec*1000000.0 == 0 */ + (double)tv0.tv_usec))/1000000.0;
   
   printf (" secs   %.8lf s. (%le s/sleep)\n", secs, secs / n );

   printf("\n");

   howmuch += 100300;
   }

}
