#include <linux/kernel.h>
#include <linux/vmalloc.h>
#include <linux/hdreg.h>
#include <linux/uaccess.h>
#include <linux/blkdev.h>
#include <linux/bio.h>

#include "interface.h"
//#define DEBUG 1

//////////////////////////////////////
///    Prototipus de les funcions
//////////////////////////////////////

struct page *xrd_lookup_page(struct xrd_device *xrd, sector_t sector);
void copy_data_to_page(const void * dst, 
		    struct page * page, unsigned int offset, size_t sz);

struct page * alloc_data_page (gfp_t gfp);

int xrd_getgeo(struct block_device * bdev, struct hd_geometry *geo);

int copy_from_xrd(void *dst, struct xrd_device *xrd,
                        sector_t sector, size_t n);

int copy_to_xrd(struct xrd_device *xrd, const void *src,
                        sector_t sector, size_t n);


///////////////////////////////////////////////////
///    Funcions que heu d'acabar d'implementar
///     (en les que està indicat)
///////////////////////////////////////////////////

static char d[4096]__attribute__((aligned(4096))) = { 1, 2, 3, 4 };

struct page * alloc_data_page (gfp_t gfp)
{
#ifdef DEBUG
	printk(KERN_DEBUG "alloc_data_page gfp     0x%08x\n", gfp);
	printk(KERN_DEBUG "  ___GFP_KSWAPD_RECLAIM 0x%08x\n", ___GFP_KSWAPD_RECLAIM);
	printk(KERN_DEBUG "  ___GFP_DIRECT_RECLAIM 0x%08x\n", ___GFP_DIRECT_RECLAIM);
	printk(KERN_DEBUG "             __GFP_ZERO 0x%08x\n", __GFP_ZERO);
	printk(KERN_DEBUG "          __GFP_HIGHMEM 0x%08x\n", __GFP_HIGHMEM);
#endif

	// la vostra implementació va aquí
	


	// fins aquí

	return NULL;
}

int xrd_getgeo(struct block_device * bdev, struct hd_geometry * g)
{
	int err = -ENODEV;
        struct xrd_device *xrd = bdev->bd_disk->private_data;

   // la vostra implementacio va aqui... 





   // fi de la vostra implementacio

        printk (KERN_DEBUG "xrd_getgeo returns\n");
        printk (KERN_DEBUG "    heads %d sectors %d\n", g->heads, g->sectors);
        printk (KERN_DEBUG "    cylinders %d start %ld\n", g->cylinders, g->start);
        return err;
}

//////////////////////////////////////////////////////////
///  Lectura de dades del disc
//////////////////////////////////////////////////////////

/*
 * Lectura d'una pàgina
 */
void copy_data_from_page(void * dst, 
		    struct page * page, unsigned int offset, size_t sz);

void copy_data_from_page(void * dst, 
		    struct page * page, unsigned int offset, size_t sz)
{
	void * src = kmap_atomic(page);
#ifdef DEBUG
	printk (KERN_DEBUG "page %p (src %p) (o %d sz %ld)\n",
			page, src, offset, sz);
#endif
	memcpy(dst, src + offset, sz);
	kunmap_atomic(src);
}

/*
 * Copy n bytes to dst from the xrd starting at sector. Does not sleep.
 */
int copy_from_xrd(void * dst, struct xrd_device * xrd,
	      			sector_t sector, size_t n)
{
	int err = -EIO;
	struct page *page;
	unsigned int offset = (sector & (PAGE_SECTORS-1)) << SECTOR_SHIFT;
	size_t copy = min_t(size_t, n, PAGE_SIZE - offset);

   // la vostra implementacio va aqui







   // fins aqui


	if (copy < n) {
		printk (KERN_DEBUG
			"copy_from_xrd: error en la implementacio %ld %ld\n", 
				copy, n);
	}
	return err;
}



//////////////////////////////////////////////////////////
///  Escriptura de dades al disc
//////////////////////////////////////////////////////////

/*
 * Escriptura d'una pàgina
 */
void copy_data_to_page(const void * src, 
		    struct page * page, unsigned int offset, size_t sz);

void copy_data_to_page(const void * src, 
		    struct page * page, unsigned int offset, size_t sz)
{
	void * dst = kmap_atomic(page);
#ifdef DEBUG
	printk (KERN_DEBUG "page %p (dst %p) (o %d sz %ld)\n",
			page, src, offset, sz);
#endif
	memcpy(dst + offset, src, sz);
	kunmap_atomic(dst);
}

/*
 * Copy n bytes from src to the xrd starting at sector. Does not sleep.
 */
int copy_to_xrd(struct xrd_device *xrd, const void *src,
                        sector_t sector, size_t n)
{
	int err = -EIO;
	struct page *page;
	unsigned int offset = (sector & (PAGE_SECTORS-1)) << SECTOR_SHIFT;
	size_t copy = min_t(size_t, n, PAGE_SIZE - offset);

   // la vostra implementacio va aqui






   // fins aqui

	if (copy < n) {
		printk (KERN_DEBUG 
			"copy_to_xrd: error en la implementacio %ld %ld\n", 
				copy, n);
	}
	return err;
}
