#include <mach/mach.h>
#include <mach/mach_error.h>
#include <mach/mig_errors.h>
#include <mach/thread_status.h>
#include <mach/processor_info.h>
#include <mach/vm_map.h>
#include <stdio.h>
#include <stdlib.h>



/*
 *      Returns information about the contents of the virtual
 *      address space of the target task at the specified
 *      address.  The returned protection, inheritance, sharing
 *      and memory object values apply to the entire range described
 *      by the address range returned; the memory object offset
 *      corresponds to the beginning of the address range.
 *      [If the specified address is not allocated, the next
 *      highest address range is described.  If no addresses beyond 
 *      the one specified are allocated, the call returns KERN_NO_SPACE.]
 */
kern_return_t vm_region_64
(
/*in   */ vm_map_read_t target_task,     // task de la que obtenir la informació
/*inout*/ vm_address_t *address,         // adreça inicial on buscar la següent
/*  out*/ vm_size_t *size,               // mida de la regió
/*in   */ vm_region_flavor_t flavor,     // tipus d'informació a obtenir
/*  out*/ vm_region_info_t info,         // informació de la regió
/*inout*/ mach_msg_type_number_t *infoCnt,  // elements a la informació
/*  out*/ mach_port_t *object_name       // memory-object associat a la regió
);


void mostra_regio(vm_address_t a, vm_size_t s, 
                  vm_region_basic_info_data_64_t * r, mach_port_t o);

int main (int argc, char * argv [])
{
   vm_region_basic_info_data_64_t region_info;
   mach_msg_type_number_t count = VM_REGION_BASIC_INFO_COUNT_64;
   task_t task;
   kern_return_t res;
   vm_address_t address;
   vm_size_t    size;

   task = mach_task_self();
   address = 0; size = 0;
   mach_port_t port;


   res = vm_region_64(task, &address, &size, VM_REGION_BASIC_INFO_64,
                   (vm_region_info_t) &region_info, &count, &port);
   if (res != KERN_SUCCESS) {
      fprintf(stderr, "vm_region: (%d) %s\n", res, mach_error_string(res));
      //exit(1);
   }

   while(res == KERN_SUCCESS) {
      //printf ("Mida %d sizeof data %ld\n", count, sizeof(region_info));

      mostra_regio(address, size, &region_info, port);

      address += size;
      res = vm_region_64(task, &address, &size, VM_REGION_BASIC_INFO_64,
                      (vm_region_info_t) &region_info, &count, &port);
      if (res != KERN_SUCCESS) {
         fprintf(stderr, "vm_region: (address %016lx, err %d) %s\n",
               address, res, mach_error_string(res));
         //exit(1);
      }
   }

   char * p = malloc(sizeof(char)*80);
   printf ("malloc (80 bytes): %p\n", p);
   p = malloc(sizeof(char)*80);
   printf ("malloc (80 bytes): %p\n", p);
   p = malloc(sizeof(char)*1024*1024);
   printf ("malloc (1MB): %p\n", p);
   p = malloc(sizeof(char)*80);
   printf ("malloc (80 bytes): %p\n", p);
   p = malloc(sizeof(char)*1024*512);
   printf ("malloc (512KB): %p\n", p);
   p = malloc(sizeof(char)*1024*256);
   printf ("malloc (256KB): %p\n", p);
   p = malloc(sizeof(char)*1024*128);
   printf ("malloc (128KB): %p\n", p);
   p = malloc(sizeof(char)*1024*64);
   printf ("malloc (64KB): %p\n", p);
   p = malloc(sizeof(char)*1024*32);
   printf ("malloc (32KB): %p\n", p);
   p = malloc(sizeof(char)*1024*16);
   printf ("malloc (16KB): %p\n", p);
   p = malloc(sizeof(char)*1024*8);
   printf ("malloc (8KB): %p\n", p);
   p = malloc(sizeof(char)*1024*4);
   printf ("malloc (4KB): %p\n", p);
   p = malloc(sizeof(char)*1024*2);
   printf ("malloc (2KB): %p\n", p);
   p = malloc(sizeof(char)*1024*1);
   printf ("malloc (1KB): %p\n", p);
   p = malloc(sizeof(char)*512);
   printf ("malloc (512 bytes): %p\n", p);
   p = malloc(sizeof(char)*256);
   printf ("malloc (256 bytes): %p\n", p);
   p = malloc(sizeof(char)*128);
   printf ("malloc (128 bytes): %p\n", p);

   return 0;
}


void mostra_regio(vm_address_t a, vm_size_t s, 
                  vm_region_basic_info_data_64_t * r, mach_port_t o)
{
 printf ("address %016lx, sz %016lx, prot %08x, maxprot %08x",
          a, s, r->protection, r->max_protection);
 printf ("                        offset %016llx  inheritance %x  shared %x\n",
          r->offset, r->inheritance, r->shared);
 printf ("                      behavior %x  wired_count %d  object %x\n",
          r->behavior, r->user_wired_count, o);
 printf ("                prot: ");
 if (r->protection == VM_PROT_NONE) printf ("VM_PROT_NONE\n");
 else {
   if (r->protection & VM_PROT_READ) printf ("VM_PROT_READ ");
   if (r->protection & VM_PROT_WRITE) printf ("VM_PROT_WRITE ");
   if (r->protection & VM_PROT_EXECUTE) printf ("VM_PROT_EXECUTE");
   printf ("\n");
 }

}
